package editor;

import game.IntRect;

import java.awt.Graphics;

public class LevelStartScreenObject extends ScreenObject {
	
	
	
	private LevelStartPaletteObject paletteObject;
	private IntRect clickRect;
	private boolean isSelected;
	
	
	public LevelStartScreenObject(int x, int y, LevelStartPaletteObject thePaletteObject) {
		
		paletteObject = thePaletteObject;
		
		int width = paletteObject.retrieveAppropriateImage().getDesiredWidth();
		int height = paletteObject.retrieveAppropriateImage().getDesiredHeight();
		
		clickRect = new IntRect(x - width/2, y - height/2, width, height);
		
	}
	
	
	
	@Override
	public void draw(Graphics g) {
		
		paletteObject.retrieveAppropriateImage().drawObjectFromUpperLeftCorner(g, clickRect.getMinX(), clickRect.getMinY());
		
		if(isSelected)
			drawSelectionOverObject(g);
		
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}

	@Override
	public void setClickRect(IntRect newRect) {
		clickRect = newRect;
	}

	@Override
	public void setSelected(boolean is) {
		isSelected = is;
	}

	@Override
	public boolean isSelected() {
		return isSelected;
	}

	
	@Override
	public int getLayer() {
		
		return 18;
	}
	
}
